package gov.va.med.mhv.integration.phr.stage.transfer;

import java.util.Date;

import org.apache.commons.lang3.StringEscapeUtils;

/**
 * User: Rob Murtha
 */
public class StageEntity  {
    private Long id;
    protected Long oplock=0L;
    protected Date createdDate;
    protected Date modifiedDate;
    protected String icn;
    protected String stationNumber;
    protected Long requestMsgCtrlId=0L;
    protected Long responseMsgCtrlId=0L;
    protected String extractStatus;
    protected String recordStatus;
    private String key;
    
    public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOplock() {
        return this.oplock;
    }

    public void setOplock(Long oplock) {
        this.oplock = oplock;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getIcn() {
        return this.icn;
    }

    public void setIcn(String icn) {
        this.icn = icn;
    }

    public String getStationNumber() {
        return this.stationNumber;
    }

    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    public Long getRequestMsgCtrlId() {
        return this.requestMsgCtrlId;
    }

    public void setRequestMsgCtrlId(Long requestMsgCtrlId) {
        this.requestMsgCtrlId = requestMsgCtrlId;
    }

    public Long getResponseMsgCtrlId() {
        return this.responseMsgCtrlId;
    }

    public void setResponseMsgCtrlId(Long responseMsgCtrlId) {
        this.responseMsgCtrlId = responseMsgCtrlId;
    }

    /** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageExtractStatusType */
    public String getExtractStatus() {
        return this.extractStatus;
    }

    /** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageExtractStatusType */
    public void setExtractStatus(String extractStatus) {
        this.extractStatus = extractStatus;
    }

    /** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageRecordStatusType */
    public String getRecordStatus() {
        return this.recordStatus;
    }

    /** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageRecordStatusType */
    public void setRecordStatus(String recordStatus) {
        this.recordStatus = recordStatus;
    }

    public StageEntityAK getAK() {
        return new StageEntityAK(icn,requestMsgCtrlId,responseMsgCtrlId);
    }

    public void setAK(StageEntityAK ak) {
        this.icn=ak.getIcn();
        this.requestMsgCtrlId=ak.getRequestMsgCtrlId();
        this.responseMsgCtrlId=ak.getResponseMsgCtrlId();
    }

    protected String doubleUnescapeHtml( String value ) {
    	return StringEscapeUtils.unescapeHtml3(StringEscapeUtils.unescapeHtml3(value));
    }
    
    public String toString1() {
        return "StageEntity{" +
                "id=" + id +
                ", oplock=" + oplock +
                ", createdDate=" + createdDate +
                ", modifiedDate=" + modifiedDate +
                ", icn='" + icn + '\'' +
                ", stationNumber='" + stationNumber + '\'' +
                ", requestMsgCtrlId=" + requestMsgCtrlId +
                ", responseMsgCtrlId=" + responseMsgCtrlId +
                ", extractStatus='" + extractStatus + '\'' +
                ", recordStatus='" + recordStatus + '\'' +
                '}';
    }

}
